<?php
/*
 * Created on 12.02.2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: MetaTest.php 264 2007-08-06 08:29:08Z nmarkgraf $
 */
// Call MetaTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
	define("PHPUnit_MAIN_METHOD", "MetaTest::main");
}

/**
 * 
 */
require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";
require_once "PHPUnit/TextUI/TestRunner.php";

/**
 * 
 */
require_once 'OpenDocumentPHP/meta/MetaDocument.php';
/**
 * Test class for manifest/ManifestDocument.
 * 
 * @author 		Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright 	Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license 	http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version    	$Revision: 264 $
 * @package    	OpenDocumentPHP
 * @subpackage	test
 * @since 		0.5.1 - 12.02.2007
 */
/**
 * 
 * @author 		Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright 	Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license 	http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version    	$Revision: 264 $
 * @package    	OpenDocumentPHP
 * @subpackage	test
 * @since 		0.5.1 - 12.02.2007
 */
class MetaTest extends PHPUnit_Framework_TestCase {
	const RelaxNG10Path = 'etc/Schemata/ODF1.0/';
	const RelaxNG11Path = 'etc/Schemata/ODF1.1/';
	const RelaxNG10Schema = 'OpenDocument-schema-v1.0-os.rng';
	const RelaxNG11Schema = 'OpenDocument-schema-v1.1-cs1.rng';
    
    private $basepath;
	
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
    public static function main() 
    {
        $result = PHPUnit_TextUI_TestRunner :: run(self::suite());
    }
    
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     * @since       0.5.3 - 02. Aug. 2007
     */
    public static function suite() 
    {
        $suite = new PHPUnit_Framework_TestSuite("meta tests");
        $suite->addTestSuite('MetaTest');
        return $suite;
    }
        
	/**
	 * Sets up the fixture, for example, open a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp() {
		$this->doc = new MetaDocument();
        if (PHPUnit_MAIN_METHOD == 'PHPUnit_TextUI_Command::main') {
            $this->basepath = "../";
        } else {
            $this->basepath = "./";
        }
	}
	/**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown() {
		unset ($this->doc);
	}
	/**
	 * 
	 */
	public function testEmptyMetaAgainstRelaxNG10Schema() {
		$meta = new MetaDocument();
		$test = $meta->relaxNGValidate($this->basepath . self :: RelaxNG10Path . self :: RelaxNG10Schema);
		$this->assertTrue($test, 'Meta document does not match Meta Relax NG schema 1.0.');
	}
	/**
	 * 
	 */
	public function testEmptyMetaAgainstRelaxNG11Schema() {
		$meta = new MetaDocument();
		$test = $meta->relaxNGValidate($this->basepath . self :: RelaxNG11Path . self :: RelaxNG11Schema);
		$this->assertTrue($test, 'Meta document does not match Meta Relax NG schema 1.1.');
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.2 - 22.02.2007
	 */
	function testLoadHTML() {
		$this->assertFalse($this->doc->loadHTML(' '));
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.2 - 22.02.2007
	 */
	function testLoadHTMLFile() {
		$this->assertFalse($this->doc->loadHTMLFile(' '));
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.2 - 22.02.2007
	 */
	function testSaveHTML() {
		$this->assertFalse($this->doc->saveHTML(' '));
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.2 - 22.02.2007
	 */
	function testSaveHTMLFile() {
		$this->assertFalse($this->doc->saveHTMLFile(' '));
	}
	/**
	 * This test should check if there is an InitialCreator.
	 * 
	 * @access		public
	 * @since 		0.5.2 - 22.02.2007
	 */
	function testGetInitialCreator() {
		$meta = $this->doc->getMetaFragment();
		$this->assertNotNull($meta);
		$this->assertType('MetaFragment', $meta);
		$this->assertEquals('', $meta->getInitialCreator());
	}
	/**
	 * This test should check if you can set an InitialCreator. 
	 * 
	 * @access		public
	 * @since 		0.5.2 - 22.02.2007
	 */
	function testSetInitialCreator() {
		$meta = $this->doc->getMetaFragment();
		$inicre = 'Test Guy';
		$this->assertNotNull($meta);
		$this->assertType('MetaFragment', $meta);
		$this->assertEquals('', $meta->getInitialCreator());
		$meta->setInitialCreator($inicre);
		$this->assertEquals($inicre, $meta->getInitialCreator());
	}
	/**
	 * This test should check if you can set a Generator. 
	 * 
	 * @access		public
	 * @since 		0.5.2 - 23.02.2007
	 */
	function testSetGenerator() {
		$meta = $this->doc->getMetaFragment();
		$inicre = 'Test Generator';
		$this->assertNotNull($meta);
		$this->assertType('MetaFragment', $meta);
		$meta->setGenerator($inicre);
		$this->assertEquals($inicre, $meta->getGenerator());
	}
	/**
	* This test should check if you can set a CreationDate. 
	* 
	* @access		public
	* @since 		0.5.2 - 23.02.2007
	*/
	function testSetCreationDate() {
		$meta = $this->doc->getMetaFragment();
		$inicre = '1970-01-02T01:00:00+01:00';
		$this->assertNotNull($meta);
		$this->assertType('MetaFragment', $meta);
		$meta->setCreationDate($inicre);
		$this->assertEquals($inicre, $meta->getCreationDate());
	}
	/**
	* This test should check if you can set a PrintDate. 
	* 
	* @access		public
	* @since 		0.5.2 - 23.02.2007
	*/
	function testSetPrintDate() {
		$meta = $this->doc->getMetaFragment();
		$inicre = '';
		$this->assertNotNull($meta);
		$this->assertType('MetaFragment', $meta);
		$this->assertEquals('', $meta->getPrintDate());
		$meta->setPrintDate($inicre);
		$this->assertEquals($inicre, $meta->getPrintDate());
	}
	/**
	* This test should check if you can set a Creator. 
	* 
	* @access		public
	* @since 		0.5.2 - 23.02.2007
	*/
	function testCreator() {
		$dc = $this->doc->getDublinCoreFragment();
		$inicre = 'Test Guy';
		$this->assertNotNull($dc);
		$this->assertType('DublinCoreFragment', $dc);
		$this->assertEquals('', $dc->getCreator());
		$dc->setCreator($inicre);
		$this->assertEquals($inicre, $dc->getCreator());
	}
	/**
	* This test should check if you can set a Language. 
	* 
	* @access		public
	* @since 		0.5.2 - 23.02.2007
	*/
	function testLanguage() {
		$dc = $this->doc->getDublinCoreFragment();
		$inicre = 'en-UK';
		$this->assertNotNull($dc);
		$this->assertType('DublinCoreFragment', $dc);
		$this->assertEquals('', $dc->getLanguage());
		$dc->setLanguage($inicre);
		$this->assertEquals($inicre, $dc->getLanguage());
	}
	/**
	* This test should check if you can set a Title. 
	* 
	* @access		public
	* @since 		0.5.2 - 23.02.2007
	*/
	function testTitle() {
		$dc = $this->doc->getDublinCoreFragment();
		$inicre = 'Test Title';
		$this->assertNotNull($dc);
		$this->assertType('DublinCoreFragment', $dc);
		$this->assertEquals('', $dc->getTitle());
		$dc->setTitle($inicre);
		$this->assertEquals($inicre, $dc->getTitle());
	}
	/**
	* This test should check if you can set a Description. 
	* 
	* @access		public
	* @since 		0.5.2 - 23.02.2007
	*/
	function testDescription() {
		$dc = $this->doc->getDublinCoreFragment();
		$inicre = 'Test Description';
		$this->assertNotNull($dc);
		$this->assertType('DublinCoreFragment', $dc);
		$this->assertEquals('', $dc->getDescription());
		$dc->setDescription($inicre);
		$this->assertEquals($inicre, $dc->getDescription());
	}
	/**
	* This test should check if you can set a Subject. 
	* 
	* @access		public
	* @since 		0.5.2 - 23.02.2007
	*/
	function testSubject() {
		$dc = $this->doc->getDublinCoreFragment();
		$inicre = 'Test Subject';
		$this->assertNotNull($dc);
		$this->assertType('DublinCoreFragment', $dc);
		$this->assertEquals('', $dc->getSubject());
		$dc->setSubject($inicre);
		$this->assertEquals($inicre, $dc->getSubject());
	}
}

if (PHPUnit_MAIN_METHOD == "MetaTest::main") {
	MetaTest::main();
}
?>
